<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('type')->nullable();
            $table->string('titre')->nullable();
            $table->text('message')->nullable();
            $table->boolean('is_read')->default(0);
            // $table->foreignId('entreprise_id')->nullable()->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('user_agent_id')->nullable()->constrained('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('compagnie_id')->nullable()->constrained('compagnie_requests')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
