<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paiments', function (Blueprint $table) {
            $table->id();
            $table->string('montant')->nullable();
            $table->string('device', 5)->nullable();
            $table->string('provider')->nullable();
            $table->string('telephone')->nullable();
            $table->boolean('is_dgrad')->nullable()->default(0);
            $table->enum('statut',['en cours', 'terminee', 'refusee', 'en attente','brouillon'])->default('en cours')->index();
            $table->string('reference')->nullable();
            $table->foreignId('entreprise_id')->nullable()->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('partenaire_id')->nullable()->constrained('partenaires')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paiments');
    }
};
