<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('compagnie_requests', function (Blueprint $table) {
            $table->id();
            $table->string('service')->nullable();
            $table->string('objet')->nullable();
            $table->string('reponse_requete')->nullable();
            $table->enum('statut',['en cours', 'terminee', 'refusee', 'en attente','brouillon'])->default('en cours')->index();
            $table->foreignId('entreprise_id')->nullable()->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('partenaire_id')->nullable()->constrained('partenaires')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('compagnie_requests');
    }
};
