<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('partenaires', function (Blueprint $table) {
            $table->id();
            $table->string('nom')->nullable();
            $table->string('type')->nullable()->index(); //assurance, banque, guichet_unique, administrateur, client
            $table->double('montant')->default(0);
            $table->string('devise',10)->nullable();
            $table->string('email')->nullable();
            $table->string('description')->nullable();
            $table->string('api_url')->nullable();
            $table->string('api_key')->nullable();            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('partenaires');
    }
};
