<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('membres', function (Blueprint $table) {
            $table->id();
            $table->string('noms')->nullable();
            $table->string('postnom')->nullable();
            $table->string('raison_sociale')->nullable();
            $table->string('forme_juridique')->nullable();
            $table->string('adresse_siege')->nullable();
            $table->boolean('numero_identification')->nullable()->default(0);
            $table->text('numero_identification_url')->nullable();
            $table->boolean('declaration_souscription')->nullable()->default(0);
            $table->text('declaration_souscription_url')->nullable();
            $table->boolean('signature')->nullable()->default(0);
            $table->text('signature_url')->nullable();
            $table->boolean('is_gerant')->nullable()->default(0); // 0 = non, 1 = oui            
            $table->enum('etat', ['actif', 'inactif'])->nullable()->default('actif');
            $table->string('numero_siege')->nullable();
            $table->string('avenue_siege')->nullable();
            $table->string('quartier_siege')->nullable();
            $table->string('commune_siege')->nullable();
            $table->string('ville_siege')->nullable();
            $table->string('province_siege')->nullable();
            $table->string('nom_dirigeant')->nullable();
            $table->string('postnom_dirigeant')->nullable();
            $table->string('prenom_dirigeant')->nullable();
            $table->string('email_dirigeant')->nullable();
            $table->string('telephone_dirigeant')->nullable();
            $table->string('nationalite_dirigeant')->nullable();
            $table->string('numero_dirigeant')->nullable();
            $table->string('avenue_dirigeant')->nullable();
            $table->string('quartier_dirigeant')->nullable();
            $table->string('commune_dirigeant')->nullable();
            $table->string('ville_dirigeant')->nullable();
            $table->string('province_dirigeant')->nullable();
            $table->boolean('formulaire_rccm')->nullable()->default(0);
            $table->text('formulaire_rccm_url')->nullable();
            $table->boolean('statuts_notarie')->nullable()->default(0);
            $table->text('statuts_notarie_url')->nullable();
            $table->string('part_association')->nullable();
            $table->foreignId('groupement_id')->nullable()->constrained('groupements')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('membres');
    }
};
