<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('groupements', function (Blueprint $table) {
            $table->id();
            //$table->string('denomination')->nullable();
            $table->string('duree_constitution')->nullable();
            $table->string('objet')->nullable();
            $table->string('numero_rccm')->nullable();
            $table->string('adresse_locaux')->nullable();
            $table->boolean('lettre_demande')->default(0);
            $table->text('lettre_demande_url')->nullable();
            $table->boolean('contrat_ecrit')->default(0);
            $table->text('contrat_ecrit_url')->nullable();
            $table->boolean('statuts_notaries')->default(0);
            $table->text('statuts_notaries_url')->nullable();
            $table->boolean('formulaire_rccm')->default(0);
            $table->text('formulaire_rccm_url')->nullable(); 
            $table->text('acte_depot_statuts_url')->nullable(); 
            $table->boolean('signature')->default(0);
            $table->string('signature_url')->nullable();            
            $table->foreignId('entreprise_id')->nullable()->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('groupements');
    }
};
