<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('associes', function (Blueprint $table) {
            $table->id();
            $table->string('prenom')->nullable();            
            $table->string('nom')->nullable();
            $table->string('postnom')->nullable();
            $table->string('email')->nullable();
            //$table->string('fonction')->nullable()->comment('Fonction du associé: ex gérant');
            $table->string('adresse_residence')->nullable();
            $table->string('nationalite')->nullable();
            $table->string('sexe')->nullable();
            $table->string('lieu_naissance')->nullable();
            $table->string('date_naissance')->nullable();
            $table->string('etat_civil')->nullable();
            $table->string('telephone')->nullable();
            $table->string('piece_identite', 20)->nullable();
            $table->text('piece_identite_url',50)->nullable();
            $table->boolean('casier_judiciaire')->nullable()->default(0);
            $table->text('casier_judiciaire_url')->nullable();
            $table->boolean('acte_naissance')->nullable()->default(0);
            $table->text('acte_naissance_url')->nullable();
            $table->boolean('acte_residence')->nullable()->default(0);
            $table->text('acte_residence_url')->nullable();
            $table->boolean('signature')->nullable()->default(0);
            $table->text('signature_url')->nullable();
            $table->enum('etat', ['actif', 'inactif'])->nullable()->default('actif');
            $table->float('pourcentage_part')->nullable();
            $table->string('valeur_part')->nullable();
            $table->string('montant_souscrit_capital')->nullable();
            $table->string('pourcentage_part_capital')->nullable();
            $table->boolean('is_gerant')->nullable()->default(0);
            $table->string('duree_mandat')->nullable();
            $table->string('date_debut_mandat')->nullable();
            $table->string('date_fin_mandat')->nullable();
            $table->string('numero_residence')->nullable();
            $table->string('avenue_residence')->nullable();
            $table->string('quartier_residence')->nullable();
            $table->string('commune_residence')->nullable();
            $table->string('ville_residence')->nullable();
            $table->string('province_residence')->nullable();
            $table->string('nom_conjoint')->nullable();
            $table->string('regime_matrimonial')->nullable();
            $table->integer('nombre_enfant')->nullable(); 
            $table->string('situation_matrimoniale')->nullable();
            $table->foreignId('societe_id')->nullable()->constrained('societes')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('associes');
    }
};
