<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('societes', function (Blueprint $table) {
            $table->id();
            //$table->string('denomination')->nullable();
            // $table->string('sigle')->nullable();
            $table->string('forme_juridique')->nullable();
            //$table->string('activite_principale')->nullable(); // voir secteur d'activité dans entreprise
            $table->string('objet_social')->nullable();
            $table->string('email',100)->nullable();   
            $table->string('telephone',20)->nullable();         
            $table->string('avenue')->nullable();
            $table->string('numero')->nullable();
            $table->string('quartier')->nullable();
            $table->string('commune')->nullable();
            $table->string('ville')->nullable();
            $table->string('province')->nullable();
            $table->string('pays')->nullable();
            $table->string('date_constitution')->nullable();
            $table->string('nombre_parts_sociale')->nullable();
            $table->string('nombre_salarie_nation')->nullable();
            $table->string('nombre_salaire_etranger')->nullable();
            $table->string('nombre_enfant_salaries')->nullable();
            $table->string('masse_salariale')->nullable();
            $table->text('site_web')->nullable();
            $table->string('duree_entreprise')->nullable();
            $table->string('apports_numeraire')->nullable();
            $table->string('apports_nature')->nullable();
            $table->string('apports_industrie')->nullable();
            //document
            $table->boolean('capital_social')->default(0); //document    
            $table->boolean('frais_administratif')->nullable()->default(0);
            $table->text('frais_administratif_url')->nullable();
            $table->boolean('statut_constitution')->nullable()->default(0);
            $table->text('statut_constitution_url')->nullable();
            $table->boolean('acte_notarie')->nullable()->default(0);
            $table->text('acte_notarie_url')->nullable();
            $table->boolean('acte_depot_statuts')->nullable()->default(0);
            $table->text('acte_depot_statuts_url')->nullable();
            $table->boolean('versement_capital_social')->nullable()->default(0);
            $table->text('versement_capital_social_url')->nullable();
            $table->string('banque_capital')->nullable();
            $table->boolean('signature')->nullable()->default(0);
            $table->text('signature_url')->nullable();
            $table->foreignId('entreprise_id')->nullable()->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('societes');
    }
};
