<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demandeurs', function (Blueprint $table) {
            $table->id();
            $table->string('prenom')->nullable();
            $table->string('postnom')->nullable();
            $table->string('nom')->nullable();
            $table->string('sexe',15)->nullable();
            $table->string('email')->nullable();
            $table->string('adresse')->nullable();
            $table->string('telephone')->nullable();
            $table->string('nationalite')->nullable();
            $table->string('rue')->nullable();
            $table->string('appartement')->nullable();            
            $table->string('lieu_naissance')->nullable();
            $table->date('date_naissance')->nullable();
            $table->string('etat_civil', 20)->nullable();
            $table->string('nom_conjoint')->nullable();
            $table->string('prenom_conjoint')->nullable();
            $table->string('piece_identite')->nullable();
            $table->text('piece_identite_url')->nullable();
            $table->boolean('acte_naissance')->default(0)->nullable();
            $table->text('acte_naissance_url')->nullable();
            $table->boolean('casier_judiciaire')->default(0)->nullable();
            $table->text('casier_judiciaire_url')->nullable();
            $table->boolean('acte_residence')->nullable()->default(0)->nullable();
            $table->text('acte_residence_url')->nullable();
            $table->boolean('signature')->nullable()->default(0);
            $table->text('signature_url')->nullable();

            //ajout 
            $table->string('avenue')->nullable();
            $table->string('numero')->nullable();
            $table->string('quartier')->nullable();
            $table->string('commune')->nullable();
            $table->string('ville')->nullable();
            $table->string('province')->nullable();
            $table->string('pays')->nullable();
            $table->string('lieu_naissance_conjoint')->nullable();
            $table->date('date_naissance_conjoint')->nullable();

            $table->foreignId('etablissement_id')->constrained('etablissements')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demandeurs');
    }
};
