<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('etablissements', function (Blueprint $table) {
            $table->id();
            //$table->string('nom')->nullable();
            $table->string('adresse')->nullable();
            $table->string('activite')->nullable();
            $table->date('date_demarrage')->nullable();
            $table->boolean('contrat_bail')->default(0)->nullable(); //1 || 0
            $table->text('contrat_bail_url')->nullable()->comment('Document url');
            $table->boolean('acte_acquisition')->default(0)->nullable(); //1 || 0
            $table->text('acte_acquisition_url')->nullable()->comment('Document url');
            $table->foreignId('entreprise_id')->constrained('entreprises')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('etablissements');
    }
};
