<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('entreprises', function (Blueprint $table) {
            $table->id();
            $table->enum('type',['etablissement','groupement','societe'])->nullable();
            $table->string('denomination')->nullable();
            $table->text('sigle')->nullable();
            $table->string('montant_capital')->nullable();
            $table->boolean('capital_social')->nullable()->default(0);
            $table->text('capital_social_url')->nullable();            
            $table->string('devise')->nullable();          
            $table->enum('statut', ['en cours', 'terminee', 'refusee', 'en attente','brouillon'])->default('en cours')->index();
            $table->dateTime('date_demande')->nullable();
            $table->dateTime('date_fin_traitement')->nullable();   
            $table->string('numero_siege')->nullable();
            $table->string('avenue_siege')->nullable();
            $table->string('quartier_siege')->nullable();            
            $table->string('ville_siege')->nullable();
            $table->string('commune_siege')->nullable();
            $table->string('province_siege')->nullable();
            $table->string('pays_siege')->nullable();         
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('secteur_activite_id')->nullable()->constrained('secteur_activites')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('entreprises');
    }
};
