<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('secteur_activites', function (Blueprint $table) {
            $table->id();
            $table->string('code')->nullable();
            $table->string('nom');            
            $table->text('description')->nullable();            
            $table->string('icon')->nullable();
            $table->enum('statut', ['actif', 'inactif'])->default('actif')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('secteur_activites');
    }
};
